/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.entity;

import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.hecco.bountifulfares.BountifulFares;
import net.hecco.bountifulfares.block.custom.GristmillBlock;
import net.hecco.bountifulfares.block.entity.BFBlockEntities;
import net.hecco.bountifulfares.block.entity.ImplementedInventory;
import net.hecco.bountifulfares.recipe.MillingRecipe;
import net.hecco.bountifulfares.screen.GristmillScreenHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class GristmillBlockEntity
extends BlockEntity
implements ExtendedScreenHandlerFactory,
ImplementedInventory {
    private static BooleanProperty millingState;
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private static final int[] TOP_SLOTS;
    private static final int[] BOTTOM_SLOTS;
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    protected final ContainerData propertyDelegate;
    private int progress = 0;
    private int maxProgress = 80;

    public GristmillBlockEntity(BlockPos pos, BlockState state) {
        super(BFBlockEntities.GRISTMILL_BLOCK_ENTITY, pos, state);
        millingState = ((GristmillBlock)state.m_60734_()).getMillingState();
        this.propertyDelegate = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> GristmillBlockEntity.this.progress;
                    case 1 -> GristmillBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        GristmillBlockEntity.this.progress = value;
                    }
                    case 1: {
                        GristmillBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    public void writeScreenOpeningData(ServerPlayer player, FriendlyByteBuf buf) {
        buf.m_130064_(this.f_58858_);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.bountifulfares.gristmill");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory playerInventory, Player player) {
        return new GristmillScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128405_("milling.progress", this.progress);
    }

    public void m_142466_(CompoundTag nbt) {
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        nbt.m_128451_("milling.progress");
        super.m_142466_(nbt);
    }

    private boolean isCrafting() {
        return this.hasRecipe() && this.canInsertOutputSlot();
    }

    public void tick(Level world, BlockPos pos, BlockState state) {
        if (!world.f_46443_) {
            if (this.maxProgress != BountifulFares.CONFIG.getMillingTime() * 20) {
                this.maxProgress = BountifulFares.CONFIG.getMillingTime() * 20;
            }
            if (!((Boolean)state.m_61143_((Property)millingState)).booleanValue() && !((ItemStack)this.inventory.get(0)).m_41619_() && this.isCrafting()) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)millingState, (Comparable)Boolean.valueOf(true)));
            }
            if (((Boolean)state.m_61143_((Property)millingState)).booleanValue() && !this.hasRecipe() && this.progress != 0) {
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)millingState, (Comparable)Boolean.valueOf(false)));
            }
            if (this.canInsertOutputSlot() && this.hasRecipe()) {
                this.increaseCraftingProgress();
                GristmillBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
                if (this.hasCraftingFinished()) {
                    this.craftItem();
                    this.resetProgress();
                }
            } else {
                this.decreaseCraftingProgress();
            }
        }
    }

    private void resetProgress() {
        this.progress = 1;
    }

    private void craftItem() {
        Optional<MillingRecipe> recipe = this.getCurrentRecipe();
        this.m_7407_(0, 1);
        this.m_6836_(1, new ItemStack((ItemLike)recipe.get().m_8043_(null).m_41720_(), this.m_8020_(1).m_41613_() + recipe.get().m_8043_(null).m_41613_()));
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private void decreaseCraftingProgress() {
        if (this.progress > 0) {
            this.progress -= 2;
        }
    }

    private boolean hasRecipe() {
        Optional<MillingRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack output = recipe.get().m_8043_(null);
        return this.canInsertAmountIntoOutputSlot(output.m_41613_()) && this.canInsertItemIntoOutputSlot(output);
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack output) {
        return this.m_8020_(1).m_41619_() || this.m_8020_(1).m_41720_() == output.m_41720_();
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.m_8020_(1).m_41741_() >= this.m_8020_(1).m_41613_() + count;
    }

    @Override
    public int[] m_7071_(Direction side) {
        if (side == Direction.DOWN) {
            return BOTTOM_SLOTS;
        }
        if (side == Direction.UP) {
            return TOP_SLOTS;
        }
        return TOP_SLOTS;
    }

    private Optional<MillingRecipe> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.m_6643_());
        for (int i = 0; i < this.m_6643_(); ++i) {
            inventory.m_6836_(i, this.m_8020_(i));
        }
        return this.m_58904_().m_7465_().m_44015_((RecipeType)MillingRecipe.Type.INSTANCE, (Container)inventory, this.m_58904_());
    }

    private boolean canInsertOutputSlot() {
        return this.m_8020_(1).m_41619_() || this.m_8020_(1).m_41613_() < this.m_8020_(1).m_41741_();
    }

    static {
        TOP_SLOTS = new int[]{0};
        BOTTOM_SLOTS = new int[]{1};
    }
}

